<?php

	// Method: POST, PUT, GET etc
	// Data: array("param" => "value") ==> index.php?param=value

	function CallAPI($method, $url, $data = false) {
		$curl = curl_init();

		switch ($method)
		{
			case "POST":
			curl_setopt($curl, CURLOPT_POST, 1);

			if ($data)
			curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
			break;
			case "PUT":
			curl_setopt($curl, CURLOPT_PUT, 1);
			break;
			default:
				if ($data)
				$url = sprintf("%s?%s", $url, http_build_query($data));
		}

		/*
		// Optional Authentication:
		curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
		curl_setopt($curl, CURLOPT_USERPWD, "username:password");
		*/

		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

		$result = curl_exec($curl);

		curl_close($curl);

		return $result;
	}
	
	$response = file_get_contents('');
	$traja = json_decode($response, true);
	$jsonpath = '../data/lots.json';
	
	$file = file_get_contents($jsonpath);
	$lotsjson = json_decode($file, true);
	
	if($traja) {
		foreach ($traja as $t => $j) {
			$trajaid = $j['numero'];
			$trajastatus = $j['status'];
			$trajaprix = $j['prix'];
			foreach ($lotsjson as $l => $t) {
				$lotid = $t['nom'];
				if ($trajaid === $lotid) {
					$lotsjson[$lotid]['prix'] = $trajaprix;
					$lotsjson[$lotid]['status'] = $trajastatus;
				}
			}
		}
		
		$json = json_encode($lotsjson);
		$writeFile = file_put_contents($jsonpath, $json);
	} else {
		response(500, "error: Donnée vide via Api", -1);
	}
	
	if($writeFile > 0){
		response(200, "success", $writeFile);
	}
	else{
		response(500, "error", $writeFile);
	}

	function response($status, $status_message, $data){
		header("HTTP/1.1 200");
		$response['status'] = $status;
		$response['data'] = $data;
		$json_response = json_encode($response);
		echo $json_response;
	}
	
	exit();

?>
