<?php
	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Headers: Content-Type');

	use PHPMailer\PHPMailer\PHPMailer;
	use PHPMailer\PHPMailer\Exception;

	require 'phpmailer/Exception.php';
	require 'phpmailer/PHPMailer.php';
	require 'phpmailer/SMTP.php';

	ini_set('display_errors', 1);
	ini_set('display_startup_errors', 1);
	error_reporting(E_ALL);
  
	$postBody = file_get_contents("php://input");
	$json = json_decode($postBody, true);
	// Save Image
	define('UPLOAD_DIR', 'capture/');
	$LE = "\r\n";
	$email = trim($json['email']);
	$img = str_replace('data:image/jpg;base64,', '', $json['imgBase64']);
	$data = base64_decode($img);
	$file = UPLOAD_DIR . $email.'.jpg';
	$success = file_put_contents($file, $data);
	$sender = "MAQUETTE V3";

	$arr = array();

	if ($success > 0) {

		$mail = new PHPMailer(true);

		try {

			$mail->addAttachment($file); 

			$mail->addAddress($email);
			$mail->setFrom('nepasrepondre@test.test', 'MAQUETTE V3');

			$mail->isHTML(true);
			$mail->Subject = 'Capture';
			$mail->Body    = 'Vous avez reçu la capture venant de ' . $sender;

			$mail->send();

			$arr = array("statusCode" => 200, "msg" => "La capture a été envoyé avec succès.", "status" => "success", "title" => "Succès");
		} catch (Exception $e) {
			$arr = array("statusCode" => 202, "msg" => "Il y a eût une erreur lors de l'envoie de la capture", "status" => "error", "title" => "Erreur");
		}
	} else {
		$arr = array("statusCode" => 201, "msg" => "L'enregistrement de l'image a échoué", "status" => "error", "title" => "Erreur");
	}

	echo json_encode($arr);

  
?>
